<?php

namespace App\Exports;

use App\Models\Stok;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;

class StokExport implements FromView
{
    protected $petugas;
    protected $tgl1;
    protected $tgl2;

    function __construct($petugas,  $tgl1, $tgl2)
    {
        $this->petugas = $petugas;
        $this->tgl1 = $tgl1;
        $this->tgl2 = $tgl2;
    }

    public function  view(): View
    {
        $data = [
            'tgl1' => 'DARI TANGGAL ' . date('d-m-Y', strtotime($this->tgl1)),
            'tgl2' => 'SAMPAI TANGGAL ' . date('d-m-Y', strtotime($this->tgl2)),
        ];

        if ($this->petugas == 'All') {
            $stok = Stok::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $this->tgl1)
                ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $this->tgl2)
                ->get();
        } else {
            $stok = Stok::where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '>=', $this->tgl1)
                ->where(DB::raw("DATE_FORMAT(created_at, '%Y-%m-%d')"), '<=', $this->tgl2)
                ->where('user_id', $this->petugas)
                ->get();
        }

        return view('admin.laporan.lap_stok', [
            'stok' => $stok,
            'no' => 1,
            'data' =>  $data,
        ]);
    }
}
